@echo off
chcp 65001 >nul
setlocal enabledelayedexpansion

:: Couleurs
:: 0E = jaune (infos)
:: 0C = rouge (erreurs)
:: 0A = vert (succès)

color 0E
echo.
echo ==========================================================
echo   Gestion sauvegarde iTunes V2.0 - Version COMBINÉE
echo.
echo	   - Protea Tech Informatique – 1647 Corbières CH -
echo ==========================================================
echo.
echo ==========================================================
echo   Cette fonction va rechercher l’emplacement actuel des
echo   sauvegardes iTunes présentes sur votre ordinateur.
echo   Le dossier trouvé sera ouvert dans l’Explorateur Windows
echo   afin que vous puissiez gérer manuellement vos fichiers
echo   (copie, suppression, archivage, etc.).
echo.
echo   Important : avant toute modification, assurez-vous
echo   que votre iPhone fonctionne correctement. Le téléphone
echo   reste lui aussi une source de sauvegarde.
echo   Ne paniquez pas en cas de suppression de fichiers : il
echo   suffira de relancer une sauvegarde via iTunes pour
echo   recréer une sauvegarde récente automatiquement.
echo ==========================================================
echo.

:: === ÉTAPE 1 : Recherche et ouverture de l’emplacement actuel ===

set "OLD_PATH=%APPDATA%\Apple Computer\MobileSync\Backup"
set "NEW_PATH=%USERPROFILE%\Apple\MobileSync\Backup"
set "count=0"

if exist "%NEW_PATH%" (
    set /a count+=1
    set "PATH!count!=%NEW_PATH%"
    echo [INFO] Détection : %NEW_PATH%
)

if exist "%OLD_PATH%" (
    set /a count+=1
    set "PATH!count!=%OLD_PATH%"
    echo [INFO] Détection : %OLD_PATH%
)

:: Vérifier si c’est un lien symbolique
if exist "%OLD_PATH%" (
    dir "%OLD_PATH%" | findstr /i "<JUNCTION>" >nul
    if not errorlevel 1 (
        for /f "tokens=5,*" %%a in ('dir "%OLD_PATH%" ^| findstr /i "<JUNCTION>"') do (
            set /a count+=1
            set "PATH!count!=%%b"
            echo [INFO] Lien symbolique détecté → %%b
        )
    )
)

if %count%==0 (
    color 0C
    echo [ERREUR] Aucun dossier de sauvegarde iTunes n’a été trouvé.
    goto :end
)

if %count%==1 (
    set "CHOICE=1"
    goto :openfolder
)

echo.
echo Plusieurs emplacements détectés :
for /L %%i in (1,1,%count%) do (
    echo   %%i. !PATH%%i!
)

set /p CHOICE=Entrez le numéro du dossier à ouvrir : 
if "%CHOICE%"=="" goto :end

:openfolder
start "" "!PATH%CHOICE%!"
color 0E
echo.
echo Le dossier a été ouvert. Vous pouvez gérer vos fichiers (copie/suppression).
pause

:: === ÉTAPE 2 : Redéfinir un nouvel emplacement ===

set /p DRIVE_LETTER=Entrez la lettre du lecteur pour le nouveau chemin désiré pour les sauvegardes iTunes (ex: D, E, F) : 
set "DRIVE_LETTER=%DRIVE_LETTER::=%"
set "DRIVE_LETTER=%DRIVE_LETTER: =%"

if not exist "%DRIVE_LETTER%:\" (
    color 0C
    echo [ERREUR] Le lecteur %DRIVE_LETTER%: n'existe pas.
    pause
    exit /b
)

set "OLD_BACKUP=%APPDATA%\Apple Computer\MobileSync\Backup"
set "NEW_BACKUP=%DRIVE_LETTER%:\Sauvegardes_iTunes"

echo.
echo [INFO] Redéfinition du dossier de sauvegarde...
if exist "%OLD_BACKUP%" rmdir /s /q "%OLD_BACKUP%"
if not exist "%NEW_BACKUP%" mkdir "%NEW_BACKUP%"
mklink /J "%OLD_BACKUP%" "%NEW_BACKUP%" >nul

color 0A
echo.
echo ================================================
echo   [SUCCÈS] Nouveau chemin appliqué :
echo   %NEW_BACKUP%
echo ================================================
echo.
echo =================================================
echo   Protea Tech Informatique – 1647 Corbières CH
echo =================================================
echo.
pause

:end
